import Link from "next/link";
import React, { useState, useEffect } from "react";
import { blog } from "../../../api/Api";
import { useRouter } from "next/router";
import jMoment from "moment-jalaali";

export default function SinglePost() {
  const [values, setValues] = useState({
    content: "",
    createdAt: "",
    description: "",
    file: "",
    sort: "",
    title: "",
  });
  const [data, setData] = useState([]);
  const router = useRouter();
  useEffect(() => {
    getThisBlog();
    getAll();
  }, []);

  const getAll = async () => {
    try {
      const { data } = await blog.getAll();

      setData(data.data);
    } catch (error) {
      console.error(error);
    }
  };

  const getThisBlog = async () => {
    try {
      const { data } = await blog.getById(router.query.id);

      setValues(data.data);
    } catch (error) {
      console.error(error);
    }
  };
  return (
    <div>
      {values && (
        <main className="content">
          <div
            className="section-main-screen section-main-screen_inner"
            style={{ backgroundImage: `url(img/bg/header.svg)` }}
          >
            <div className="wrapper">
              <div className="main-screen main-screen_inner">
                <div className="h1 h1-2">مقاله</div>
                <ul
                  className="breadcrumbs"
                  itemScope=""
                  itemType="https://schema.org/BreadcrumbList"
                >
                  <li
                    itemProp="itemListElement"
                    itemScope=""
                    itemType="https://schema.org/ListItem"
                  >
                    <a href="#" itemProp="item">
                      <span itemProp="name">خانه</span>
                    </a>
                    <meta itemProp="position" content="1" />
                  </li>
                  <li
                    itemProp="itemListElement"
                    itemScope=""
                    itemType="https://schema.org/ListItem"
                  >
                    <a href="#" itemProp="item">
                      <span itemProp="name">بلاگ</span>
                    </a>
                    <meta itemProp="position" content="2" />
                  </li>
                </ul>
                <div className="leaf-left-decor"></div>
              </div>
              <div className="circle-decor"></div>
            </div>
            <div className="leaf-right-decor"></div>
          </div>
          <div className="section-post section-post-inner">
            <div className="wrapper">
              <div className="columns" style={{textAlign:'right'}}>
                <div className="columns_center">
                  <article className="article-wrap">
                    <div className="article">
                      <picture>
                        <source
                          type="image/jpeg"
                          srcSet="img/examples/article.jpg"
                          media="(min-width: 768px)"
                        />
                        <source
                          type="image/jpeg"
                          srcSet="img/examples/article_mob.jpg"
                        />
                        <img
                          src="img/examples/article_mob.jpg"
                          alt=""
                          className="img-article-main"
                        />
                      </picture>
                      <div className="news-header news-header_article" >
                        <div className="news__date">
                          {jMoment(values.createdAt).format("jYYYY/jMM/jDD")}
                        </div>
                        {/* <div className="news__author">
                          <img
                            dataSrc="img/examples/avatar_2.jpg"
                            alt=""
                            className="js-lazy"
                            src="data:image/gif;base64,R0lGODlhAQABAAAAACw="
                          />
                          {/* <span className="news__author-title">
                            Annette Black
                          </span> 
                        </div>
                        <a href="blog.html" className="news__category">
                          Community
                        </a> */}
                      </div>
                      <h1>{values.title}</h1>
                      <p>
                      
                      </p>
                      <blockquote style={{textAlign:'justify'}}>
                        {values.description}
                        {/* <cite>Ralph Edwards</cite> */}
                      </blockquote>
                      <div
                        style={{ padding: "20px" }}
                        dangerouslySetInnerHTML={{
                          __html: values && values.content,
                        }}
                      />
                     
                    </div>
                   
                  </article>
                </div>
                <aside className="columns_sidebar sidebar">
                  <div className="sidebar_search">
                    <form>
                      <div className="search">
                        <input type="text" placeholder="جستجو ...." />
                        <button type="submit">
                          <span className="icon-search"></span>
                        </button>
                      </div>
                    </form>
                  </div>
                  <div className="sidebar-widget sidebar-widget_post">
                    <h3 className="sidebar-widget__title">پست های اخیر</h3>
                    <div className="stories">
                      {data &&
                        data.map((x) => {
                          return (
                            <div key={Math.random()} className="stories-item">
                              <a
                                href="#"
                                className="stories-item__img"
                              >
                                <img
                                  dataSrc="img/examples/img1.jpg"
                                  src={x.file}
                                  className="js-lazy"
                                  alt=""
                                />
                              </a>
                              <div className="stories-item__infoline">
                                <div className="stories-item__title">
                                <Link key={Math.random()} href={`/BlogPage/${x.id}`}>
                                  <a href="">{x.title}</a>
                                </Link>
                                </div>
                                <div className="stories-item__date">
                                  {jMoment(x.createdAt).format("jYYYY/jMM/jDD")}
                                </div>
                              </div>
                            </div>
                          );
                        })}
                    </div>
                  </div>
                  <div className="sidebar-widget sidebar-widget_datepicker">
                    <div id="datepicker" className="datepicker"></div>
                  </div>
                 
                </aside>
              </div>
            </div>
          </div>
        </main>
      )}
    </div>
  );
}
